#ifndef LOGGER_H /******************************************************************************** -*- c++ -*- **/
#define LOGGER_H

#include <sys/cdefs.h>
#include <stdarg.h>

__BEGIN_DECLS
/****************************************************************************************************************/

void die(const char *txt, ...);
void warn(const char *txt, ...);
void msg(const char *txt, ...);

void vdie(const char *txt, va_list va);
void vmsg(const char *txt, va_list va);
void vwarn(const char *txt, va_list va);

void sdie(const char *txt);
void swarn(const char *txt);
void smsg(const char *txt);

void dumpdata(const char *tag, const char *buf, int len);

/****************************************************************************************************************/

typedef void log_handler_t(const char *txt, int len);

void setLogHandler(log_handler_t *h);
log_handler_t *queryLogHandler(void);

void stderr_log_handler(const char *txt, int len);

/****************************************************************************************************************/
__END_DECLS
#endif
