#ifndef _CORE_WAIT_H_ /******************************************************************************************/
#define _CORE_WAIT_H_

/****************************************************************************************************************/

#define WNOHANG		1
#define WUNTRACED	2
#define WSTOPPED	WUNTRACED
#define WEXITED		4
#define WCONTINUED	8

/****************************************************************************************************************/

#define WEXITSTATUS(status)	(((status) & 0xFF00) >> 8)
#define WTERMSIG(status)	((status) & 0xFF)
#define WSTOPSIG(status)	(((status) & 0xFF00) >> 8)

#define WIFEXITED(status)	(((status) & 0xFF) == 0)
#define WIFSTOPPED(status)	(((status) & 0xFF) == 0x7F)
#define WIFSIGNALED(status)	({ int __st = status; (!WIFSTOPPED(__st)) && (!WIFEXITED(__st)); })
#define WIFCORED(status)        (status & 0x10000)
#define WCOREDUMP WIFCORED
#define WIFCONTINUED(status)    (status & 0x20000)

/****************************************************************************************************************/

#define W_EXITCODE(ret, sig)	((ret) << 8 | (sig))
#define W_STOPCODE(sig)		((sig) << 8 | 0x7f)

/****************************************************************************************************************/
#endif
