#ifndef _NET_IF_H_ /*********************************************************************************************/
#define _NET_IF_H_

#include <core/types.h>
#include <core/socket.h>
#include <core/sockios.h>

/****************************************************************************************************************/

#define IF_NAMESIZE	16
#define IFHWADDRLEN	6
#define IFNAMSIZ	IF_NAMESIZE

/****************************************************************************************************************/

struct ifreq {
  union {
    char ifrn_name[IFNAMSIZ];
  } ifr_ifrn;

  union {
    struct sockaddr ifru_addr;
    struct sockaddr ifru_broadaddr;
    struct sockaddr ifru_netmask;
    struct sockaddr ifru_hwaddr;
    unsigned int ifru_flags;
    unsigned int ifru_trace;
    int ifru_ivalue;
    int ifru_mtu;
    char ifru_newname[IFNAMSIZ];
  } ifr_ifru;
};

#define ifr_name	ifr_ifrn.ifrn_name
#define ifr_hwaddr	ifr_ifru.ifru_hwaddr
#define ifr_addr	ifr_ifru.ifru_addr
#define ifr_broadaddr	ifr_ifru.ifru_broadaddr
#define ifr_netmask	ifr_ifru.ifru_netmask
#define ifr_metric	ifr_ifru.ifru_ivalue
#define ifr_flags	ifr_ifru.ifru_flags
#ifdef __CORE4_VISIBLE
#define ifr_trace	ifr_ifru.ifru_trace
#endif
#define ifr_mtu		ifr_ifru.ifru_mtu
#define ifr_newname	ifr_ifru.ifru_newname
#define ifr_ifindex	ifr_ifru.ifru_ivalue

/****************************************************************************************************************/

#define IFF_UP			0x0001		// Interface is ready to talk
#define IFF_BROADCAST		0x0002		// Has a broadcast address
#define IFF_DEBUG		0x0004		// Tracing support
#define IFF_LOOPBACK		0x0008		// This is a loopback interface
#define IFF_RUNNING		0x0040		// Resources allocated
#define IFF_PROMISC		0x0100		// Receive all packets
#define IFF_MULTICAST		0x1000		// Can do multicast
#define IFF_DYNAMIC		0x8000		// Automagically does DHCP

/****************************************************************************************************************/

#ifdef __CORE4_VISIBLE
#define NET_TRACE_ARP			1
#define NET_TRACE_ARP_CACHE		2
#define NET_TRACE_ARP_CACHE_LOOKUP	4
#define NET_TRACE_DHCP			8
#define NET_TRACE_DHCP_DUMP		16
#define NET_TRACE_IP			32
#define NET_TRACE_TCP			64
#define NET_TRACE_UDP			128
#endif

/****************************************************************************************************************/
#endif
