#ifndef BARCODE_QRCODE_H
#define BARCODE_QRCODE_H

class CodeQR {
public:
  CodeQR();
  ~CodeQR();

public:
  void setVersion(int v)  { m_version = v; }	// -4..-1=MicroQR, 0=Auto, 1..40=NormalQR
  void setEcLevel(int l)  { m_eclevel = l; }	// 0=Auto, 1=L, 2=M, 3=H, 4=Q

  int version(void) const { return m_version; }
  int ecLevel(void) const { return m_eclevel; }

public:
  bool generate(const char *barcode, unsigned int barlen = 0);

  void clear(void);

public:
  unsigned int size(void) const;		// Number of modules (pixels) in x and y direction
  unsigned int pixel(int x, int y) const;	// Get pixel value at coordinate
  const unsigned char *bits(void) const;	// Return raw bitmap buffer (2bpp, 00=white, else black)

private:
  int m_version;
  int m_eclevel;

  struct State;
  State *m_state;
};

#endif
