#ifndef POLLTABLE_H /********************************************************************************************/
#define POLLTABLE_H

/****************************************************************************************************************/

#include <sys/poll.h>
#include <sys/cdefs.h>
#include <stdlib.h>

/****************************************************************************************************************/

struct polltable;
typedef int pollcallback_t(int fd, int revents, void *data);

/****************************************************************************************************************
 *
 * Return values for ptab_poll()
 *
 */
#define PTPR_SUCCESS	0
#define PTPR_ERROR	-1
#define PTPR_MAXNEST	-2

/****************************************************************************************************************/

__BEGIN_DECLS

// Alloc/free
struct polltable *ptab_alloc(unsigned int max);
void ptab_free(struct polltable *ptab);

// Interface
int ptab_add(struct polltable *ptab, int fd, int events, pollcallback_t *cb, void *data);
void ptab_rem(struct polltable *ptab, int fd);
int ptab_poll(struct polltable *ptab, int timeout);

int ptab_poll_start(struct polltable *ptab, int timeout);
void ptab_poll_finish(struct polltable *ptab);
void ptab_reset(struct polltable *ptab);

// Debug
void ptab_dump(struct polltable *ptab);

__END_DECLS

/****************************************************************************************************************/
#endif
