#ifndef _TIME_H_ /***********************************************************************************************/
#define _TIME_H_

#include <sys/time.h>
#include <core/time.h>
#include <sys/cdefs.h>

__BEGIN_DECLS

/****************************************************************************************************************/

struct tm {
  int     tm_sec;         /* seconds */
  int     tm_min;         /* minutes */
  int     tm_hour;        /* hours */
  int     tm_mday;        /* day of the month */
  int     tm_mon;         /* month */
  int     tm_year;        /* year */
  int     tm_wday;        /* day of the week */
  int     tm_yday;        /* day in the year */
  int     tm_isdst;       /* daylight saving time */
  long    tm_gmtoff;      /* Seconds east of UTC */
  const char *tm_zone;    /* Timezone abbreviation */
};

/****************************************************************************************************************/

time_t time(time_t *t);

#define CLOCKS_PER_SEC 1000

clock_t clock(void);

double difftime(time_t time1, time_t time0);

void tzset(void);

/****************************************************************************************************************/

char *asctime(const struct tm *tm);
char *asctime_r(const struct tm *tm, char *buf);

char *ctime(const time_t *timep);
char *ctime_r(const time_t *timep, char *buf);

struct tm *gmtime(const time_t *timep);
struct tm *gmtime_r(const time_t *timep, struct tm *result);

time_t timegm(struct tm *tm);

struct tm *localtime(const time_t *timep);
struct tm *localtime_r(const time_t *timep, struct tm *result);

time_t mktime(struct tm *tm);

/****************************************************************************************************************/

size_t strftime(char *s, size_t maxsize, const char *format, const struct tm *timep);
char *strptime(const char *s, const char *format, struct tm *tm);

/****************************************************************************************************************/

extern long timezone;
extern long altzone;
extern int daylight;
extern const char *tzname[2];

/****************************************************************************************************************/

#ifndef NULL
#define NULL 0L
#endif

/****************************************************************************************************************/
__END_DECLS
#endif
