#ifndef _TEXT_SPLIT_H_
#define _TEXT_SPLIT_H_

/****************************************************************************************************************/

#include <stdlib.h> /* WIN32: size_t */
#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

// This will split the passed commandline into the passed argv array.
// Code knows about \x and quotes.
//
// The code changes the contents of <cmdline>.
//
// It is assumed that argv can hold <count> items.
// Since a NULL pointer is placed after the last item, that means
// that at most <count>-1 arguments can be parsed.
//
// Returns the number of arguments placed into argv.
int text_split_argv(char *cmdline, char **argv, size_t count);

#ifdef __cplusplus
}
#endif

/****************************************************************************************************************/
#endif
