#ifndef _SYS_DIRENT_H_
#define _SYS_DIRENT_H_

/****************************************************************************************************************/

#include <core/dirent.h>
#include <sys/cdefs.h>

/****************************************************************************************************************/

typedef struct {
  int dd_fd;          // File descriptor used for directory
  int dd_loc;         // Position in buffer
  char *dd_buf;       // Directory buffer
  int dd_len;         // Directory buffer length
  int dd_size;        // Number of bytes used in buffer
} DIR;

/****************************************************************************************************************/

__BEGIN_DECLS

DIR *opendir(const char *path);
struct dirent *readdir(DIR *dir);
void rewinddir(DIR *dir);
int closedir(DIR *dir);

int scandir(const char *dir, struct dirent ***namelist,
	    int (*filter)(struct dirent *),
	    int (*compare)(const struct dirent *const *, const struct dirent *const *));

int alphasort(const struct dirent *const *d1, const struct dirent *const *d2);

static __inline__ int dirfd(DIR *dir) { return dir->dd_fd; }

__END_DECLS

/****************************************************************************************************************/

#include <core/syscall/dirent.h>

/****************************************************************************************************************/
#endif
