#ifndef _STDLIB_H_ /*********************************************************************************************/
#define _STDLIB_H_

#include <sys/types.h>
#include <inttypes.h>
#include <core/syscall/stdlib.h>
#include <sys/cdefs.h>

__BEGIN_DECLS

/****************************************************************************************************************/

#ifndef NULL
#define NULL 0L
#endif

#define EXIT_FAILURE	1
#define EXIT_SUCCESS	0

/****************************************************************************************************************/

typedef struct div_t {
  int quot;
  int rem;
} div_t;

typedef struct ldiv_t {
  long quot;
  long rem;
} ldiv_t;

typedef struct lldiv_t {
  long long quot;
  long long rem;
} lldiv_t;

/****************************************************************************************************************/

div_t div(int numerator, int denominator);
ldiv_t ldiv(long numerator, long denominator);
lldiv_t lldiv(long long numerator, long long denominator);

/****************************************************************************************************************/

static inline int abs(int j)                       { if (j < 0) return -j; else return j; }
static inline long int labs(long int j)            { if (j < 0) return -j; else return j; }
static inline long long int llabs(long long int j) { if (j < 0) return -j; else return j; }

/****************************************************************************************************************/

void *calloc(size_t nmemb, size_t size);
void *malloc(size_t size);
void free(void *ptr);
void *realloc(void *ptr, size_t size);
void malloc_dump(int fd);

/****************************************************************************************************************/

void *bsearch(const void *needle, const void *haystack, size_t nmemb, size_t size,
	      int (*compar)(const void *, const void *));

void qsort(void *aa, size_t n, size_t es, int (*cmp)(const void *, const void *));

/****************************************************************************************************************/

int atoi(const char *ptr);
double atof(const char *nptr);
long atol(const char *nptr);
long long atoll(const char *nptr);

long int strtol(const char *nptr, char **endptr, int base);
long unsigned int strtoul(const char *nptr, char **endptr, int base);
long long strtoll(const char *nptr, char **endptr, int base);
double strtod(const char *nptr, char **endptr);

long long strtonum(const char *nptr, long long minval, long long maxval, const char **errstr);

/****************************************************************************************************************/

int mblen(const char *s, size_t n);
size_t mbstowcs(wchar_t *dest, const char *src, size_t n);
int mbtowc(wchar_t *pwc, const char *s, size_t n);
int wctomb(char *s, wchar_t wc);
size_t wcstombs(char *dest, const wchar_t *src, size_t n);

/****************************************************************************************************************/

void exit(int status) __attribute__((__noreturn__));

/****************************************************************************************************************/

int system(const char *command);

/****************************************************************************************************************/

void abort(void);

/****************************************************************************************************************/
// random() is implemented as a system call, getting randomness from the in-kernel generator.
// srandom() does nothing, as the kernel won't have people mucking about.

static inline void srandom(unsigned int dummy) { }

/****************************************************************************************************************/

#define RAND_MAX 0x7FFFFFFF

int rand_r(unsigned int *seed);
int rand(void);
void srand(unsigned int seed);

/****************************************************************************************************************/

int mkstemp(char *tmplte);
char *mktemp(char *tmplte);
char *mkdtemp(char *tmplte);
int mkstemps(char *tmplte, int suffixlen);

char *realpath(const char *path, char *resolved_path);

/****************************************************************************************************************/

#define ATEXIT_MAX	1000
int atexit(void (*function)(void));

/****************************************************************************************************************/

char *getenv(const char *name);
int setenv(const char *name, const char *value, int rewrite);
void unsetenv(const char *name);
int putenv(const char *str);

/****************************************************************************************************************/
__END_DECLS
#endif
