#ifndef _MAG_MAGSTRIPE_H_
#define _MAG_MAGSTRIPE_H_

#include <sys/types.h>
#include <core/magstripe.h>
#include <magbits.h>

/****************************************************************************************************************/

struct magcode {
  uint16 mc_start;
  uint16 mc_stop;
  uint16 mc_offset;
  uint16 mc_bits;
  uint32 mc_flags;
};

/****************************************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern const struct magcode mag_encodings[3];

int mag_decode(const struct magcode *enc, const void *data, size_t len, void *buf, size_t *bufsize_p);

#ifdef __cplusplus
}
#endif

/****************************************************************************************************************/
#endif
