
------------------------------------------------------------------------------------------------------------------
--
-- Generate code
--
local enums = {};
local declarations = {};
local start = {};
local done = {};
local names = {};

local idx = 0

for line in io.lines("vk-seqstates.def") do
  -- Remove whitespace
  local line = string.gsub(string.gsub(line, "^%s+", ""), "%s+$", "")

  if (string.len(line) > 0) then

    idx = idx + 1

    if (string.byte(line, 1) == 35) then

      -- Comment
      local comment = '\n  //' .. string.sub(line, 2) .. '\n'
      enums[idx] = comment;
      start[idx] = comment;
      done[idx] = comment;
      names[idx] = comment;

      local comment = '//' .. string.sub(line, 2) .. '\n'
      declarations[idx] = comment;

    else

      -- State
      local state   = string.lower(line)
      local ucstate = string.upper(line)

      enums[idx] = "  STATE_" .. ucstate .. ",\n"

      start[idx] = string.format('  case STATE_%s: start_%s(vkp); return;\n',
				 ucstate, state)

      done[idx]  = string.format('  case STATE_%s: done_%s(vkp); return;\n',
				 ucstate, state)

      names[idx] = string.format('  case STATE_%s: return "%s";\n',
				 ucstate, state)

      declarations[idx] = string.format([[
static void start_%s(struct vk_driver *vkp);
static void done_%s(struct vk_driver *vkp);

]], state, state, state)

    end
  end
end

------------------------------------------------------------------------------------------------------------------

function begin_file(filename)
  local df = io.open(filename, "wb");
  df:write('//\n// Automagically generated from vk-seqstates.def\n//\n')
  return df
end

------------------------------------------------------------------------------------------------------------------
--
-- Write enum table
--
df = begin_file("vk-seqstates-decl.h")

df:write('enum vk_seq_state {\n')
for nr = 1,idx do
  df:write(enums[nr])
end
df:write('};\n\n')

df:write('const char *vk_seq_state_name(enum vk_seq_state state);\n\n')

df:close()

------------------------------------------------------------------------------------------------------------------
--
-- Write function prototypes
--
df = begin_file("vk-seqstates-code.h")

df:write('#include "vk-seqstates-decl.h"\n\n')

for nr = 1,idx do
  df:write(declarations[nr])
end

df:write('\n');

--
-- Write start state jump table
--
df:write('static void start_state(struct vk_driver *vkp) {\n')
df:write('  switch((enum vk_seq_state)vkp->vks_seq_state) {\n')
for nr = 1,idx do
  df:write(start[nr])
end
df:write('  }\n')
df:write('  state_bug(vkp, __LINE__);\n')
df:write('}\n\n')

--
-- Write done state jump table
--
df:write('static void process_response(struct vk_driver *vkp) {\n')
df:write('  switch((enum vk_seq_state)vkp->vks_seq_state) {\n')
for nr = 1,idx do
  df:write(done[nr])
end
df:write('  }\n')
df:write('  state_bug(vkp, __LINE__);\n')
df:write('}\n\n')
df:close()

------------------------------------------------------------------------------------------------------------------
--
-- Write name lookup table
--
df = begin_file("vk-seqstates-name.c")

df:write('#include "vk-seqstates-decl.h"\n\n')

df:write('const char *vk_seq_state_name(enum vk_seq_state state) {\n')
df:write('  switch((enum vk_seq_state)state) {\n')
for nr = 1,idx do
  df:write(names[nr])
end
df:write('  }\n')
df:write('  return 0;\n')
df:write('}\n\n')

df:close()

------------------------------------------------------------------------------------------------------------------
