#ifndef VK_ENUM_H
#define VK_ENUM_H

/****************************************************************************************************************/
//
// Type of detected reader
//
enum vk_reader_type {
  V4KF,
  V2BF,
  V2XF,
};

/****************************************************************************************************************/
//
// Card types -- also defined in lua/v4kf.lh
//
enum vk_chip_type {
  vkcNone		=	0,	// Chip type not known
  vkcMemory		=	1,	// Unknown memory chip with ATR
  vkcMemorySLE4442	=	2,	// Infineon SLE4442
  vkcMemorySLE4432	=	3,	// Infineon SLE4432
  vkcMemorySLE4428	=	4,	// Infineon SLE4428
  vkcMemorySLE4418	=	5,	// Infineon SLE4418
  vkcMemoryI2C11	=	6,	// IC cards with 11bit addressing
  vkcMemoryI2C16	=	7,	// IC cards with 16bit addressing
  vkcSmartcard		=	255,	// Smartcard protocols
};

#ifdef VK_CONFIG_TINYBUF
#define VK_CHIP_BUFSIZE 258	// 256 bytes max APDU size + 2 bytes status
#else
#define VK_CHIP_BUFSIZE 4096
#endif

/****************************************************************************************************************/
//
// State of reader
//
enum vk_state {
  vkReset,
  vkInitializing,
  vkClosed,
  vkAccepting,
  vkInserted,
  vkLocked,
  vkEjecting,
  vkProcessing,
  vkCapturing,
};

/****************************************************************************************************************/
//
// Sensors
//
enum vk_sensor {
  vksS0     = 0,
  vksS1     = 1,
  vksS2     = 2,
  vksS3     = 3,
  vksS4     = 4,
  vksWID    = 5,
  vksSHD    = 6,
  vksSHE    = 7,
  vksICA    = 8,
  vksCHE    = 9,
  vksTamper = 10,
  vksMotor0 = 11,
  vksMotor1 = 12,
};

/****************************************************************************************************************/
//
// Flags for insert command
//
enum vk_insert_flags {
  vkiAutolock          = 1, // Automatically lock (V4KF) and press chip contact
  vkiCheckForMagstripe = 2, // Only accept cards with magstripe (V2XF only)
  vkiWiggle            = 4, // Wiggle card around while pulling it in to thwart skimming (V2XF only)
};

/****************************************************************************************************************/
//
// Flags for smartcard chip enable command
//
enum vk_chip_flags {
  vkcAll = 1,
  vkcEfid = 2,
  vkcTrack2Equivalent = 4,
  vkcATR = 8,
  vkcPan = 16,
  vkcName = 32,
};

/****************************************************************************************************************/
//
// Error codes
//
#define VK_BUSY			0x525000	// State machine is busy
#define VK_DTR_TIMEOUT		0x525001	// Reader not ready
#define VK_OVERFLOW		0x525003	// Transmit buffer overflow
#define VK_TIMEOUT		0x525004	// Protocol timed out
#define VK_SHORT_RESPONSE	0x525005	// Received response is too short
#define VK_INVALID_RESPONSE	0x525006	// Received response is invalid (sanity check failed)
#define VK_INVALID_COMMAND	0x525007	// Invalid command passed for transmission
#define VK_BUG			0x5250FF	// Umh...

#define VK_RDR_OFFLINE		0x525301	// Reader is offline
#define VK_RDR_INVALID_SEQ	0x525302	// Invalid command sequence requested
#define VK_RDR_INVALID_VERSION	0x525303	// Version probing failed
#define VK_RDR_INVALID_PARAMETER 0x525304	// Invalid parameter passed
#define VK_RDR_NO_CARD		0x525305	// No card in reader
#define VK_RDR_BUSY		0x525306	// Sequence queue full
#define VK_RDR_TYPE_UNKNOWN	0x525307	// Cannot detect type of reader

#define VK_RDR_STATE_BUG	0x5253FF	// Bug in state machine

#define VK_RDR_ERROR		0x565B00	// Lower 8 bits indicate error code from reader

#define CHIP_ENABLE_FAILED	0x434800	// Chip activation failed
#define CHIP_READ_FAILED	0x434801	// Chip read command
#define CHIP_WRITE_FAILED	0x434802	// Chip write command
#define CHIP_BUFFER_OVERFLOW	0x434803	// Provided buffer was too small

/****************************************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

const char *vk_state_name(enum vk_state st);
const char *vk_strerror(int error_code);

#ifdef __cplusplus
}
#endif

/****************************************************************************************************************/

#endif
