#ifndef LIBKEYBOARD_KEYBOARD_CPP_H /*************************************************************** -*- c++ -*- */
#define LIBKEYBOARD_KEYBOARD_CPP_H

/****************************************************************************************************************/

#include <sys/types.h>

#include <keyboard/scancodes.h>
#include <keyboard/event.h>

#include <emb/object.h>
#include <emb/events.h>

/****************************************************************************************************************/
//
// High level API
//
struct keyboard;

class Keyboard : public Object {

public:
  Keyboard(Object *par = 0, const char *n = 0);
  ~Keyboard();

public:
  bool init(void);
  bool openDevice(const char *dev);

public:
  void setCountry(int country);
  void setLEDs(int leds);
  void enableClick(bool flag);

public: // Callback
  // Can be reimplemented to process low level events.
  // Default implementation sends a KeyEvent to parent.
  virtual void keyboardEvent(const struct keyboard_event *ev);

private:
  struct keyboard *m_kbd;
};

/****************************************************************************************************************/

class KeyboardEvent : public Event {
public:
  KeyboardEvent(const struct keyboard_event *ev);

public:
  uint location(void) const  { return kev->location;  }	// Source of event (e.g. USB location ID)
  uint scancode(void) const  { return kev->scancode;  }	// Scancode of key
  uint value(void) const     { return kev->value;     }	// KEYVAL_UP, KEYVAL_DOWN or KEYVAL_REPEAT
  uint modifiers(void) const { return kev->modifiers; }	// State of modifiers (Shift, Ctrl, ...)
  uint unicode(void) const   { return kev->unicode;   }	// Unicode character, or ~0 if none available.

  const struct keyboard_event *event(void) const { return kev; }

private:
  const struct keyboard_event *kev;
};

/****************************************************************************************************************/
#endif
