#ifndef MD5SUM_H /******************************************************************************** -*- c++ -*- **/
#define MD5SUM_H

/****************************************************************************************************************/

class MD5Checksum {

public: //interface functions for the RSA MD5 calculation
  static void md5(const void *buf, unsigned int len, unsigned char *out);

protected: //constructor/destructor
  
  MD5Checksum();

  //RSA MD5 implementation
  void Transform(const unsigned char Block[64]);
  void Update(const unsigned char *Input, unsigned long nInputLen);
  void Final(unsigned char *out);
  inline unsigned long RotateLeft(unsigned long x, int n);
  inline void FF(unsigned long &A, unsigned long B, unsigned long C, unsigned long D, unsigned long X, unsigned long S, unsigned long T);
  inline void GG(unsigned long &A, unsigned long B, unsigned long C, unsigned long D, unsigned long X, unsigned long S, unsigned long T);
  inline void HH(unsigned long &A, unsigned long B, unsigned long C, unsigned long D, unsigned long X, unsigned long S, unsigned long T);
  inline void II(unsigned long &A, unsigned long B, unsigned long C, unsigned long D, unsigned long X, unsigned long S, unsigned long T);

  //utility functions
  inline void DWORDToByte(unsigned char *Output, const unsigned long *Input, unsigned int nLength);
  inline void ByteToDWORD(unsigned long *Output, const unsigned char *Input, unsigned int nLength);

private:
  unsigned char m_lpszBuffer[64];	//input buffer
  unsigned long m_nCount[2];		//number of bits, modulo 2^64 (lsb first)
  unsigned long m_lMD5[4];		//MD5 checksum
};

/****************************************************************************************************************/

#endif
