#ifndef ERRTXT_H /******************************************************************************** -*- c++ -*- **/
#define ERRTXT_H

/****************************************************************************************************************/

class ErrTxt {

public: // Construction
  ErrTxt();
  ~ErrTxt();

private: // Not allowed, has dynamic memory
  ErrTxt(const ErrTxt &);
  ErrTxt &operator =(const ErrTxt &);

public:
  const char *lastError(void) const { return m_last_error; }
  void clearLastError(void);

protected:
  void fmtLastError(const char *txt, ...);

  void setLastError(const char *txt);
  void setLastError(int err);

  void setLastError(const char *ctxt, const char *txt);
  void setLastError(const char *ctxt, int err);

  void setLastError(const char *ctxt, unsigned int line, const char *txt);
  void setLastError(const char *ctxt, unsigned int line, int err);

private:
  char *m_last_error;
};

/****************************************************************************************************************/

#endif
