#ifndef CONFIGFILE_H /**************************************************************************** -*- c++ -*- **/
#define CONFIGFILE_H

/****************************************************************************************************************/

#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <stdio.h>

/****************************************************************************************************************/

#include "textfile.h"

class ConfigFile : public TextFile {
public:
  ConfigFile(unsigned int maxsize = 131072, unsigned int maxlines = 1000);
  ~ConfigFile();

  void clearval(void);

public:
  int section(const char *name) const; // Find starting line of given section

  // Raw strings
  const char *getValue(const char *sect, const char *tag);
  bool setValue(const char *sect, const char *tag, const char *value);
  bool remValue(const char *sect, const char *tag) { return setValue(sect, tag, 0); }

  // Decoded strings
  unsigned int getNumber(const char *sect, const char *tag, unsigned int dflt = 0);
  const char *getString(const char *sect, const char *tag, const char *dflt = 0);
  bool getIP4(const char *sect, const char *tag, struct in_addr *ipaddr);
  bool getBool(const char *sect, const char *tag, bool dflt = false);
  ssize_t getRaw64(const char *sect, const char *tag, void *buf, size_t bufsize);
  ssize_t getRawHex(const char *sect, const char *tag, void *buf, size_t bufsize);
  const char *getHexString(const char *sect, const char *tag);

  bool setString(const char *sect, const char *tag, const char *str);
  bool setNumber(const char *sect, const char *tag, unsigned int n);
  bool setHex(const char *sect, const char *tag, unsigned int n);
  bool setHex8(const char *sect, const char *tag, unsigned int n);
  bool setHex16(const char *sect, const char *tag, unsigned int n);
  bool setHex24(const char *sect, const char *tag, unsigned int n);
  bool setHex32(const char *sect, const char *tag, unsigned int n);
  bool setIP4(const char *sect, const char *tag, const struct in_addr &ipaddr);
  bool setBool(const char *sect, const char *tag, bool n);
  bool setRaw64(const char *sect, const char *tag, const void *data, size_t count);
  bool setRawHex(const char *sect, const char *tag, const void *data, size_t count);
  bool setHexString(const char *sect, const char *tag, const char *str);

  bool checkPassword(const char *sect, const char *tag, const char *str);
  bool setPassword(const char *sect, const char *tag, const char *str);

private:
  int findValue(const char *sect, const char *tag, const char **valptr, unsigned int *lenptr) const;
  int findValue(int startline, const char *tag, const char **valptr, unsigned int *lenptr) const;

  bool setNumber(const char *sect, const char *tag, unsigned int n, const char *fmt);

private:
  char m_valbuf[4096];
};

/****************************************************************************************************************/

#endif
