#ifndef _CORE_VENDING_H_ /***************************************************************************************/
#define _CORE_VENDING_H_

/****************************************************************************************************************/

struct vend_packet {
  uint  vp_flags;			// Flags for this request
  uint  vp_address;			// Target node address
  uint  vp_command;			// Command
  uint  vp_interval;			// Polling interval
  uint  vp_timeout;			// Timeout for response in ms (0 = use default)
  int   vp_datalen;			// Tx: Length of command data   Rx: >0:Length of response <0:error
  uint8 vp_data[0];			// Command data
};

/****************************************************************************************************************/
//
// vp_flags
//
#define VEND_ACK		  0x01	// Send an ACK to device when result was read by application

/****************************************************************************************************************/

#define VEND_REGISTER_POLL	0x5652	// Takes a vend packet and sets up regular polling
#define VEND_UNREGISTER_POLL	0x5655	// Takes a vend packet and unregisters it

/****************************************************************************************************************/
#endif
