#ifndef _SIDEKICK_PINS_H_ /**** USED BY LUA ********************************************************************/
#define _SIDEKICK_PINS_H_

/***************************************************************************************************************/
//
// Numbering of generic IO pins
//
#define SKIO_IN0		0 	// J8.1, J10.7
#define SKIO_IN1		1 	// J8.2, J10.5
#define SKIO_IN2		2 	// J8.13, J10.9
#define SKIO_IN3		3 	// J8.14, J10.10
#define SKIO_IN4		4 	// J13.22
#define SKIO_IN5		5 	// J13.24
#define SKIO_IN6		6 	// J13.20
#define SKIO_IN7		7 	// J13.25

#define SKIO_OUT0		8 	// J10.6
#define SKIO_OUT1		9 	// J10.8
#define SKIO_OUT2		10 	// J10.4
#define SKIO_OUT3		11 	// J10.2
#define SKIO_OUT4		12 	// J10.3
#define SKIO_OUT5		13 	// J13.5
#define SKIO_OUT6		14 	// J13.6
#define SKIO_OUT7		15 	// J13.23

#define SKIO_LED0		16	// J8.10
#define SKIO_LED1		17	// J8.11
#define SKIO_LED2		18	// J8.7
#define SKIO_LED3		19	// J8.9
#define SKIO_LED4		20	// J8.12
#define SKIO_LED5		21	// J8.8
#define SKIO_LED6		22 	// n/a
#define SKIO_LED7		23 	// n/a

#define SKIO_LIGHT		24	// J9.16, J9.18 (both via N-FET & 4.7 Ohms)

#define SKIO_CDR0		25	// J13.7		S1
#define SKIO_CDR1		26	// J13.8		S2
#define SKIO_CDR2		27	// J13.9		S3
#define SKIO_CDR3		28	// J13.21		WIDTH
#define SKIO_CDR4		29	// J13.22		SHD
#define SKIO_CDR5		30	// J13.24		SHE
#define SKIO_CDR6		31	// J13.10 via PNP Transistor
#define SKIO_CDR7		32	// J13.20
#define SKIO_CDR8		33	// J13.25
#define SKIO_CDR9		34	// J13.5		MFS
#define SKIO_CDR10		35	// J13.6		MRS
#define SKIO_CDR11		36	// J13.23		SO

#define SKIO_RDT1		37	// J13.11		RDT1
#define SKIO_RCP1		38	// J13.12		RCP1
#define SKIO_RDT2		39	// J13.13		RDT2
#define SKIO_RCP2		40	// J13.14		RCP2
#define SKIO_RDT3		41	// J13.15		RDT3
#define SKIO_RCP3		42	// J13.16		RCP3

#define SKIO_DD0		43	// J9.11
#define SKIO_DD1		44	// J9.12
#define SKIO_DD2		45	// J9.13
#define SKIO_DD3		46	// J9.14
#define SKIO_DRS		47	// J9.4
#define SKIO_DE1		48	// J9.6
#define SKIO_DE2		49	// J9.20

#define SKIN_WHEELA		57	// External controlpanel wheel signal A
#define SKIN_CENTER		58	// External controlpanel wheel center button
#define SKIN_WHEELB		59	// External controlpanel wheel signal B
#define SKIN_LEFT		60	// External controlpanel cursor left
#define SKIN_DOWN		61	// External controlpanel cursor down
#define SKIN_RIGHT		62	// External controlpanel cursor right
#define SKIN_UP			63	// External controlpanel cursor up

#define SKIO_COUNT		64

/***************************************************************************************************************/
#endif
