------------------------------------------------------------------------------------------------------------------
--
-- Main application event handler
--
app = event.new()
shell = app:shell()

------------------------------------------------------------------------------------------------------------------
--
-- Initialize graphics display for printing information messages, if available.
-- All messages are also printed to the debug serial port.
--
fb = gfx.open()
if (fb) then
  fb:cls()
  fb:font(gfx.font("/usr/lib/fonts/6x8.lfn"))
  dbgtrm = fb:terminal()
  dbgtrm:write("\033[20h", "\033%G", "\033[?97l")  -- Autofeed, UTF8 mode, enable updates and redraw
end

function dbg(fmt, ...)
  local ok,txt = pcall(string.format, fmt, ...)
  if (dbgtrm) then dbgtrm:write(txt, "\n") end
  print(txt)
end

------------------------------------------------------------------------------------------------------------------
--
-- This defines the 16-bit numeric codes used for messaging.
-- This file must be shared between client and server code, so both agree on the same codes.
--
dofile("/usr/lib/lua/tags.lua")

------------------------------------------------------------------------------------------------------------------
--
-- Include the server and client components
--
dofile("/usr/lib/lua/server.lua")
dofile("/usr/lib/lua/client.lua")

------------------------------------------------------------------------------------------------------------------
--
-- Main loop
--

client_start()
server_start()

while true do app:poll() end

------------------------------------------------------------------------------------------------------------------
